/*
 * Copyright (c) 2024, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
package jdk.internal.event;

/**
 * Event recording file reads.
 */
public final class FileReadEvent extends Event {

    // The order of these fields must be the same as the parameters in
    // commit(..., String, long, boolean)
    public String path;
    public long bytesRead;
    public boolean endOfFile;

    public static boolean enabled() {
        // Generated by JFR
        return false;
    }

    public static long timestamp() {
        // Generated by JFR
        return 0L;
    }

    public static boolean shouldCommit(long duration) {
        // Generated by JFR
        return false;
    }

    public static void commit(long start, long duration, String path, long bytesRead, boolean endOfFile) {
        // Generated by JFR
    }
}
